% MATLAB code: Example 11.4, Figure 11.4
% File: LVSTAR_CNF.m
%
% Generation of 2 nonlinear VLSTAR series with CNF:
%   Y_{1,t} = 0.8  + (-0.3 0.5)(Y_{1,t-1} Y_{2,t-1})' + term 
%   Y_{2,t} = -0.3 + (0.2  0.1)(Y_{1,t-1} Y_{2,t-1})' + term
%
% where 
%   term = (2 1)'(0.5+0.2Y_{1,t-1}+0.3Y_{2,t-1})G(Y_{2,t-1};gamma,c)+epsilon_{t}
% with
%   G(.) = (1+exp{-(Y_{2,t-}-1)})^{-1}
%   epsilon_{t} ~ iid N(0,I_{2})
%
% Stationary linear combination:
%   Y_{t} = 0.5 + 0.2Y_{1,t-1}+0.3Y_{2,t-1}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all;

nr      = 1000;
mu      = [0, 0];
Sigma   = [1, 0; 0, 1];
R       = mvnrnd(mu,Sigma,nr+1);
X       = normrnd(0,1,nr+1,1);
y1(1)   = 0;
y2(1)   = 0;
ylin(1) = 0;

for i=2:nr+1
    g(i) = (1+exp(-(y2(i-1) - 1)))^(-1);
    
    y1(i)   = 0.8  - 0.3*y1(i-1)+0.5*y2(i-1) ...
              + 2*(0.5+0.2*y1(i-1)+0.3*y2(i-1))*g(i)+R(i,1);
    y2(i)   = -0.3 + 0.2*y1(i-1)+0.1*y2(i-1) ...
              + 1*(0.5+0.2*y1(i-1)+0.3*y2(i-1))*g(i)+R(i,2);
    ylin(i) = (0.5+ 0.2*y1(i-1)+0.3*y2(i-1)); % stationary linear combination      
end

for i=1:200
    index(i) = i;
    z1(i)    = y1(i+800);  
    z2(i)    = y2(i+800);   
    zlin(i)  = ylin(i+800);  % linear combination 
end

indext = index'; 
zlint  = zlin';
z1t    = z1';
z2t    = z2';

plot(indext,z1t,'b',indext,z2t,'r')